/*#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <math.h>
*/
#include <stdio.h>
#include <dos.h>

#define    IN_BUF_SIZE      1024
#define    NoError	    0
#define    InitPinIsOpen    0
#define    InitPinIsNotOpen 1
#define    QueueIsEmpty     0
#define    QueueIsNotEmpty  1
#define    PortError	   -1
#define    DataError	   -2
#define    ParityError	   -3
#define    StopError	   -4
#define    TimeOut	   -5
#define    QueueEmpty	   -6
#define    QueueOverflow   -7
#define    PosError	   -8
#define    AddrError	   -9
#define    BlockError	   -10
#define    WriteError	   -11
#define    SegmentError    -12
#define    BaudRateError   -13
#define    CheckSumError   -14
#define    ChannelError    -15
#define    TimeIsUp        1

void InitLib(void);
int  InstallCom(int port, unsigned long baud, int data, int parity, int stop);
int  RestoreCom(int port);
int  IsCom(int port);
int  ReadCom(int port);
int  ToCom(int port, int data);
int  ToComBufn(int port,char *buf,int no);
int  ToComStr(int port, char *str);
int  ClearCom(int port);
int  WaitTransmitOver(int port);
int  Set485DirToTransmit(int port);
int  Set485DirToReceive(int port);

int  ReadInitPin(void);
void LedOff(void);
void LedOn(void);
void Init5DigitLed(void);
int  Show5DigitLed(int position, int value);
//int  Show5DigitLedSeg(int pos, unsigned char data);
int Show5DigitLedSeg(int pos,int value);
void DelayTimeMs(unsigned int time);

int  ReadNVRAM(int addr);
int  WriteNVRAM(int addr, int data);

int  WriteEEP(int block, int addr, int data);
int  ReadEEP(int block, int addr);
void EnableEEP(void);
void ProtectEEP(void);

void EnableWDT(void);
void RefreshWDT(void);
void DisableWDT(void);

int FlashReadId(void);
int FlashWrite(unsigned int seg, unsigned int offset, char data);
int FlashErase(unsigned int seg);
int FlashRead(unsigned int seg, unsigned int offset);

void Delay(unsigned ms);
void Delay_1(unsigned ms);

int Is7188(void);
int getch4(void);
int kbhit4(void);
int ungetch4(int key);
void putch4(int data); 

#define SEND_CMD(port,cmd,timeout,checksum)  SendCmdTo7000(port,cmd,checksum)
#define RECEIVE_CMD ReceiveResponseFrom7000
extern char hex_to_ascii[16];
int ascii_to_hex(char ascii);
int SendCmdTo7000(int iPort, unsigned char *cCmd, int iChksum);
int ReceiveResponseFrom7000(int iPort, unsigned char *cCmd, long lTimeout, int iChksum);

void far *_MK_FP(unsigned segment,unsigned offset);
int IsResetByWatchDogTimer(void);
int IsResetByPowerOff(void); /* for bios date 12/12/98 or later */

int Show5DigitLedWithDot(int pos, int data);
void Set5DigitLedTestMode(int mode);
void Set5DigitLedIntensity(int mode);
void Disable5DigitLed(void);
void Enable5DigitLed(void);
unsigned GetLibVersion(void);

/* 01/07/1999  Add Timer function */
int TimerOpen(void);
int TimerClose(void);
void TimerResetValue(void);
unsigned long TimerReadValue(void);
void DelayMs(unsigned t);
int StopWatchReset(int channel);
int StopWatchStart(int channel);
int StopWatchStop(int channel);
int StopWatchPause(int channel);
int StopWatchContinue(int channel);
int StopWatchReadValue(int channel,unsigned long *value);
int CountDownTimerStart(int channel,unsigned long count);
int CountDownTimerReadValue(int channel,unsigned long *value);
void InstallUserTimer(void (*fun)(void));
void InstallUserTimer1C(void (*fun)(void));
int IsCom3OutBufEmpty(void);
int IsCom4OutBufEmpty(void);
int DataSizeInCom(int port);
int DataSizeInCom1(void);
int DataSizeInCom2(void);
int DataSizeInCom3(void);
int DataSizeInCom4(void);
/* New for Ver 1.13 */
/* 07-23-1999 add 4 function for COM1 /DTR,/RTS output pins */
void SetDtrActive(void);
void SetDtrInactive(void);
void SetRtsActive(void);
void SetRtsInactive(void);

/* [New for Ver 1.14] */
/**** 07/27/1999 add 5 function for COM1/2/3/4 formated output ****/
int printCom(int port,char *fmt,...);
int printCom1(char *fmt,...);
int printCom2(char *fmt,...);
int printCom3(char *fmt,...);
int printCom4(char *fmt,...);
/* 08/06/1999 add 2 function for COM1 CTS,DSR input pins */
int GetCtsStatus(void);
int GetDsrStatus(void);

/* 08/25/1999 add 5 function for COM1-4 */
int IsTxBufEmpty(int port);
int IsTxBufEmpty1(void);
int IsTxBufEmpty2(void);
int IsTxBufEmpty3(void);
int IsTxBufEmpty4(void);
